<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Facultad de Ciencias Económicas de la Universidad Nacional de San Martín - UNSM">
    <meta name="keywords" content="UNSM, Facultad de Ciencias Económicas, Universidad San Martín, Administración, Contabilidad, Economía, Turismo">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#2D8139">

    <title>Facultad de Ciencias Económicas - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../css/style.css">
    <!-- Stylesheet Ciencias Económicas -->
    <link rel="stylesheet" href="css/styleCienEco.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../ciencias agrarias/agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="indexCienEco.php" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="#administracion">Administración</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                    <li><a href="#economia">Economía</a></li>
                                    <li><a href="#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../educacion y humanidades/indexEdu.php" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../educacion y humanidades/indexEdu.php#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../educacion y humanidades/indexEdu.php#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../educacion y humanidades/psicologia/indexPsico.php">Psicología</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Facultad -->
    <section class="eco-banner">
        <div class="banner-image">
            <img src="img/banner-economia.jpg" alt="Estudiantes de Ciencias Económicas" onerror="this.src='https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=1600'">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-container">
            <div class="banner-content">
                <div class="facultad-logo">
                    <img src="../../imagenes/Escudos de Facultades — UNSM/FCE-UNSM-2021.png" alt="Logo de la Facultad de Ciencias Económicas" width="180" height="180">
                </div>
                <div class="banner-text">
                    <span class="facultad-label">FACULTAD DE</span>
                    <h1>CIENCIAS ECONÓMICAS</h1>
                    <p class="banner-subtitle">ADMINISTRACIÓN / CONTABILIDAD / ECONOMÍA / TURISMO</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Facultad y Misión -->
    <section class="facultad-section">
        <div class="facultad-container">
            <!-- Contenido Principal -->
            <div class="facultad-main-content">
                <div class="content-grid">
                    <!-- Facultad -->
                    <div class="content-block">
                        <div class="section-badge">
                            <span class="badge-circle">NUESTRA</span>
                            <h2 class="section-title">FACULTAD</h2>
                        </div>
                        <div class="facultad-content">
                            <p>Nuestra comunidad educativa de Ciencias Económicas debe trabajar continua y mancomunadamente en un modelo de organización centrado. Con imaginación creativa, ideas emprendedoras y visión para enfrentarnos en una estrategia que se identifique para con las próximas generaciones, preservando la autonomía intelectual, representativa del claustro docente y libertad académica.</p>
                        </div>
                    </div>

                    <!-- Misión -->
                    <div class="content-block">
                        <div class="section-badge">
                            <span class="badge-circle">NUESTRA</span>
                            <h2 class="section-title">MISIÓN</h2>
                        </div>
                        <div class="facultad-content">
                            <p>Somos una Facultad Acreditada, formadora de profesionales competitivos y emprendedores, con valores, principio ético, comprometidos con el desarrollo sostenible de las ciencias agrarias, con responsabilidad social y ambiental.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar de Eventos -->
            <aside class="eventos-sidebar">
                <div class="eventos-container">
                    <h3>Próximos Eventos</h3>
                    <p class="no-eventos">No hay nuevos eventos.</p>
                    <div class="eventos-actions">
                        <button class="btn-add">Añadir</button>
                        <a href="#" class="btn-calendar">Ver Calendario</a>
                    </div>

                    <div class="contactenos-box">
                        <h4>Contáctenos</h4>
                        <p><strong>Campus principal:</strong></p>
                        <p>Jr. Maynas N. 177 - Tarapoto - Perú</p>
                        <p><strong>Teléfono:</strong> (+51) (042) 48 0159</p>
                        <p><strong>Email:</strong> informes@unsm.edu.pe</p>
                        <p><strong>Horario:</strong> Lunes a Viernes 7:00am a 2:30pm</p>
                    </div>
                </div>
            </aside>
        </div>
    </section>

    <!-- Carreras Profesionales -->
    <section class="carreras-section">
        <div class="carreras-container">
            <div class="section-badge">
                <span class="badge-circle">NUESTRAS</span>
                <h2 class="section-title">ESCUELAS</h2>
            </div>

            <div class="carreras-grid">
                <!-- Administración -->
                <div class="carrera-card" id="administracion">
                    <div class="carrera-image">
                        <img src="img/administracion.jpg" alt="Administración" onerror="this.src='https://images.unsplash.com/photo-1552664730-d307ca884978?w=800'">
                        <div class="carrera-overlay">
                            <h3>ADMINISTRACIÓN</h3>
                        </div>
                    </div>
                    <div class="carrera-info">
                        <p class="carrera-description">Forma profesionales capaces de gestionar y dirigir organizaciones públicas y privadas con eficiencia, liderazgo y visión estratégica para el desarrollo empresarial.</p>
                        <a href="#" class="btn-carrera">Ver más</a>
                    </div>
                </div>

                <!-- Contabilidad -->
                <div class="carrera-card" id="contabilidad">
                    <div class="carrera-image">
                        <img src="img/contabilidad.jpg" alt="Contabilidad" onerror="this.src='https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=800'">
                        <div class="carrera-overlay">
                            <h3>CONTABILIDAD</h3>
                        </div>
                    </div>
                    <div class="carrera-info">
                        <p class="carrera-description">Prepara profesionales especializados en el registro, análisis e interpretación de la información financiera y contable de las organizaciones.</p>
                        <a href="#" class="btn-carrera">Ver más</a>
                    </div>
                </div>

                <!-- Economía -->
                <div class="carrera-card" id="economia">
                    <div class="carrera-image">
                        <img src="img/economia.jpg" alt="Economía" onerror="this.src='https://images.unsplash.com/photo-1611974789855-9c2a0a7236a3?w=800'">
                        <div class="carrera-overlay">
                            <h3>ECONOMÍA</h3>
                        </div>
                    </div>
                    <div class="carrera-info">
                        <p class="carrera-description">Forma economistas con capacidad de análisis, investigación y formulación de políticas económicas para el desarrollo regional y nacional.</p>
                        <a href="#" class="btn-carrera">Ver más</a>
                    </div>
                </div>

                <!-- Turismo -->
                <div class="carrera-card" id="turismo">
                    <div class="carrera-image">
                        <img src="img/turismo.jpg" alt="Turismo" onerror="this.src='https://images.unsplash.com/photo-1488646953014-85cb44e25828?w=800'">
                        <div class="carrera-overlay">
                            <h3>TURISMO</h3>
                        </div>
                    </div>
                    <div class="carrera-info">
                        <p class="carrera-description">Prepara profesionales en gestión turística, planificación de destinos y promoción del patrimonio cultural y natural de la región amazónica.</p>
                        <a href="#" class="btn-carrera">Ver más</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../admision/indexAdmin.php">Admisión</a></li>
                    <li><a href="../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../js/script.js" defer></script>
</body>
</html>
